#include "taxi_report.h"
#include "config.h"

#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/http/io/stream.h>


bool TTaxiPriceReport::Parse(const TString& rawData) {
    DEBUG_LOG << rawData << Endl;
    if (!ReadJsonFastTree(rawData, &OriginalReport)) {
        return false;
    }
    const NJson::TJsonValue& options = OriginalReport["options"][0];
    const NJson::TJsonValue& price = options["price"];
    if (!price.IsDouble()) {
        DEBUG_LOG << "Incorrect data format" << Endl;
        return false;
    }
    Price = price.GetDoubleSafe();
    const NJson::TJsonValue& waiting = options["waiting_time"];
    if (waiting.IsDouble()) {
        WaitingTime = waiting.GetDoubleSafe();
    }
    return true;
}

bool TTaxiShardInfo::ParseReport(const TString& data, const TString& /*firstLine*/, TTaxiPriceReport& result, ui32& httpCode) {
    try {
        httpCode = ParseHttpRetCode(data);
    } catch (...) {
        return false;
    }
    TMemoryInput dataStream(data.data(), data.size());
    THttpInput httpInput(&dataStream);
    return result.Parse(httpInput.ReadAll());
}

void TTaxiReportBuilder::DoOnReplyReady() const {
    ui32 httpCode = HTTP_OK;

    TMap<ui32, TTaxiPriceReport> replies;
    for (auto&& i : ShardsResults) {
        if (i.GetHttpCode() == HTTP_OK) {
            replies[i.GetShardId()] = *i.GetReport();
        }
        httpCode = ::Max(httpCode, i.GetHttpCode());
    }
    ReplyCallback->OnReplyReady(replies, httpCode);
}

TTaxiReportBuilder::TTaxiReportBuilder(const TTaxiModuleConfig& moduleConfig, IReplyProcessor::TPtr cb)
    : ModuleConfig(moduleConfig)
    , ReplyCallback(cb)
{
    CHECK_WITH_LOG(ReplyCallback);
    Y_UNUSED(ModuleConfig);
}

TTaxiReportBuilder::~TTaxiReportBuilder() {
}
