#pragma once

#include <rtline/library/async_proxy/shards_report.h>

#include <library/cpp/json/json_value.h>

class TTaxiModuleConfig;

class TTaxiPriceReport {
public:
    const NJson::TJsonValue& GetOriginalReport() const {
        return OriginalReport;
    }

    double GetPrice() const {
        return Price;
    }

    double GetWaitingTime() const {
        return WaitingTime;
    }

    bool Parse(const TString& rawData);

private:
    NJson::TJsonValue OriginalReport;
    double Price = 0.0;
    double WaitingTime = 0.0;
};


class TTaxiShardInfo: public TShardReport<TTaxiPriceReport> {
public:
    TTaxiShardInfo(IShardDelivery* shardInfo)
        : TShardReport<TTaxiPriceReport>(shardInfo)
    {
    }

    virtual bool ParseReport(const TString& data, const TString& firstLine, TTaxiPriceReport& result, ui32& httpCode) override;
};


class TTaxiReportBuilder: public TShardsReportBuilder<TTaxiShardInfo> {
public:
    class IReplyProcessor {
    public:
        using TPtr = TAtomicSharedPtr<IReplyProcessor>;

        virtual ~IReplyProcessor() {}
        virtual void OnReplyReady(const TMap<ui32, TTaxiPriceReport>& results, ui16 httpCode) = 0;
    };

    TTaxiReportBuilder(const TTaxiModuleConfig& moduleConfig, IReplyProcessor::TPtr cb);
    ~TTaxiReportBuilder();

    IEventLogger* GetEventLogger() const override {
        return nullptr;
    }

protected:
    virtual void DoOnReplyReady() const override;

private:
    const TTaxiModuleConfig& ModuleConfig;
    IReplyProcessor::TPtr ReplyCallback;
};
