#pragma once

#include <rtline/util/network/neh.h>

#include <library/cpp/tvmauth/client/facade.h>

namespace NDrive {
    inline const TString TaxiCommunicationsProductionEndpoint = "http://ucommunications.taxi.yandex.net";
    inline const TString TaxiCommunicationsTestingEndpoint = "http://ucommunications.taxi.tst.yandex.net";

    inline const ui32 TaxiCommunicationsProductionTvmId = 2012118;
    inline const ui32 TaxiCommunicationsTestingTvmId = 2012116;

    class TTaxiCommunicationsClient {
    public:
        struct TOptions {
            NSimpleMeta::TConfig MetaConfig = NSimpleMeta::TConfig::ForRequester();
            TString Endpoint = TaxiCommunicationsTestingEndpoint;
            TString PushHandle = "/user/notification/push";

            TDuration DefaultTimeout = TDuration::MilliSeconds(500);
            NTvmAuth::TTvmId DestinationClientId = 0;
        };

    public:
        TTaxiCommunicationsClient(const TOptions& options, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr, TAsyncDelivery::TPtr ad = nullptr);

        NThreading::TFuture<void> Push(
            NJson::TJsonValue&& data,
            const TString& taxiUserId,
            const TString& intent,
            const TString& idempotencyToken,
            TDuration ttl = TDuration::Zero(),
            TDuration timeout = TDuration::Zero()
        ) const;

    private:
        ui32 GetDestinationClientId() const;

    private:
        const TOptions Options;

        TAtomicSharedPtr<NNeh::THttpClient> Client;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
    };
}
