#include <drive/library/cpp/taxi/request.h>
#include <rtline/library/async_proxy/ut/helper/helper.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <library/cpp/logger/global/global.h>


Y_UNIT_TEST_SUITE(DriveSuite) {

    class TReplyProcessor: public TTaxiReportBuilder::IReplyProcessor {
    public:
        TReplyProcessor(ui16 httpCode, ui32 resultsCount)
            : HttpCode(httpCode)
            , ResultsCount(resultsCount) {}

        void OnReplyReady(const TMap<ui32, TTaxiPriceReport>& results, ui16 httpCode) override {
            DEBUG_LOG << httpCode << Endl;
            UNIT_ASSERT_VALUES_EQUAL(httpCode, HttpCode);
            for (auto&& i : results) {
                DEBUG_LOG << i.first << ": " << i.second.GetPrice() << Endl;
            }
            UNIT_ASSERT_VALUES_EQUAL(results.size(), ResultsCount);
        }

    private:
        ui16 HttpCode;
        ui32 ResultsCount;
    };


    Y_UNIT_TEST(TestSimpleTaxiRequest) {
        InitGlobalLog2Console(TLOG_DEBUG);

        TPortManager portManager;

        TTaxiModuleConfig config;
        config.StatusPort = portManager.GetPort(1300);
        config.StatusHost = "localhost";
        config.ApiKey = "42";

        auto taxiServer = NAPHelper::BuildServer(config.StatusPort, 4, TDuration::Seconds(0), 200);
        taxiServer->SetReply("{'options':[{'price':10852,'waiting_time':112.27611660957336}]}");
        taxiServer->SetNeedHeader(false);
        TGeoCoord from(37.582042682896905, 55.7525362319659);
        TGeoCoord to(37.56311701608782, 55.74941392632123);
        TTaxiRequest req(from, to);

        TSimpleTaxiClient taxiClient(config);
        auto reply = taxiClient.SendRequest(req, TDuration::MilliSeconds(1500));
        UNIT_ASSERT_VALUES_EQUAL(reply->GetCode(), 200);
        UNIT_ASSERT_VALUES_EQUAL(reply->GetReport().GetPrice(), 10852);
    }
}
