#include <drive/library/cpp/taxi/taxi_report.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TaxiReportSuite) {
    Y_UNIT_TEST(ParseChecks) {
        TTaxiPriceReport report;
        UNIT_ASSERT(
            report.Parse("{\"options\":[{\"price_text\":\"~974 rub\",\"class_name\":\"econom\",\"price\":974,\"class_level\":50,\"class_text\":\"Economy\",\"min_price\":172}],\"time\":3902.2,\"currency\":\"RUB\",\"distance\":25681.26957,\"time_text\":\"1 h 10 min\"}")
        );
        UNIT_ASSERT_VALUES_EQUAL(report.GetPrice(), 974);
    }
}
