#pragma once

#include <library/cpp/yson/node/node.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/map.h>

namespace NDrive {
    const NYT::TNode* GetPositionDataPtr(const NYT::TNode& data);
    const NYT::TNode& GetPositionData(const NYT::TNode& data);
    TMaybe<double> GetCustomParameter(const NYT::TNode& data, const TStringBuf name);
    TMap<TString, double> GetCustomParameters(const NYT::TNode& data);
    void GetCustomParameters(const NYT::TNode& data, TMap<TString, double>& sensors);

    double GetLatitude(const NYT::TNode& data);
    double GetLongitude(const NYT::TNode& data);
    double GetCourse(const NYT::TNode& data);
    double GetSpeed(const NYT::TNode& data);
    TInstant GetTimestamp(const NYT::TNode& data);
}
