#include "container.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ThreadSafeContainer) {
    Y_UNIT_TEST(Function) {
        std::function f = [] (int value) {
            return value * 1.0;
        };
        auto container = MakeThreadSafeContainer(std::move(f));
        static_assert(std::is_same_v<decltype(f), decltype(container)::TValueType::TValueType>);
        UNIT_ASSERT(container);
        UNIT_ASSERT(*container);
        auto released = container->Release();
        UNIT_ASSERT(released);
        UNIT_ASSERT(*released);
        auto releasedAgain = container->Release();
        UNIT_ASSERT(!releasedAgain);
    }
}
