#pragma once

#include <util/datetime/base.h>
#include <util/generic/maybe.h>

namespace NJson {
    class TJsonValue;
}

namespace NThreading {
    class IEventLogger {
    public:
        virtual ~IEventLogger() = default;

        virtual void AddEvent(TInstant timestamp, NJson::TJsonValue&& e) = 0;
        virtual void AddEvent(NJson::TJsonValue&& ev);
        virtual bool ShouldRecordEventLog() const = 0;
    };
    using TEventLoggerPtr = TAtomicSharedPtr<IEventLogger>;

    class TEventLoggerGuard {
    public:
        TEventLoggerGuard(TEventLoggerPtr value);
        ~TEventLoggerGuard();

    private:
        TEventLoggerPtr PreviousValue;
    };

    class TEventGuardTraits {
    protected:
        TEventGuardTraits(const TString& name);

        NJson::TJsonValue BuildStartEvent();
        NJson::TJsonValue BuildFinishEvent(TInstant finish);

    protected:
        const TString Name;
        const TInstant Start;
    };

    class TEventGuard: public TEventGuardTraits {
    public:
        TEventGuard(const TString& name, IEventLogger& logger);
        TEventGuard(const TEventGuard& other) = delete;
        ~TEventGuard();

        void AddEvent(NJson::TJsonValue&& ev) {
            Logger.AddEvent(std::move(ev));
        }

    private:
        IEventLogger& Logger;
    };

    using TOptionalEventGuard = TMaybe<TEventGuard>;
    TOptionalEventGuard BuildEventGuard(const TString& name);

    TEventLoggerPtr CaptureEventLogger();
    IEventLogger* GetEventLogger();
}
