#include "future.h"

#include <rtline/library/scheduler/global.h>

void NThreading::NPrivate::Schedule(TInstant timestamp, std::function<void()>&& f) {
    Y_ENSURE_BT(TGlobalScheduler::Schedule(timestamp, std::move(f)));
}

bool NThreading::TLazyPromise::SetValue() {
    if (Promise.Initialized()) {
        Promise.SetValue();
        return true;
    } else {
        return false;
    }
}

NThreading::TFuture<void> NThreading::TLazyPromise::GetFuture() {
    if (!Promise.Initialized()) {
        Promise = NewPromise<void>();
    }
    return Promise.GetFuture();
}
