#pragma once

#include "future.h"

#include <rtline/library/json/cast.h>

namespace NJson {
    template <class T>
    TJsonValue ToJson(const NThreading::TFuture<T>& object) {
        if (!object.Initialized()) {
            return JSON_NULL;
        }
        if (object.HasValue()) {
            return ToJson(object.GetValue());
        }
        if (object.HasException()) {
            TJsonValue result;
            result["exception"] = NThreading::GetExceptionInfo(object);
            return result;
        }
        return "future_pending";
    }

    template <>
    inline TJsonValue ToJson(const NThreading::TFuture<void>& object) {
        if (!object.Initialized()) {
            return JSON_NULL;
        }
        if (object.HasValue()) {
            return "void";
        }
        if (object.HasException()) {
            TJsonValue result;
            result["exception"] = NThreading::GetExceptionInfo(object);
            return result;
        }
        return "future_pending";
    }
}
