#include "future.h"

#include <library/cpp/threading/future/async.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(FutureExtensionSuite) {
    Y_UNIT_TEST(Exception) {
        TThreadPool pool;
        pool.Start(2);
        {
            auto future = NThreading::MakeFuture<int>(42);
            UNIT_ASSERT(NThreading::GetExceptionMessage(future).empty());
            UNIT_ASSERT(!NThreading::GetException(future));
        }
        {
            auto future = NThreading::Async([] {
                throw yexception() << "error";
            }, pool);
            future.Wait();
            UNIT_ASSERT(NThreading::GetException(future));
            UNIT_ASSERT_VALUES_EQUAL(NThreading::GetExceptionMessage(future), "error");
        }
        {
            NThreading::TFuture<int> error = NThreading::TExceptionFuture() << "not today";
            UNIT_ASSERT(error.HasException());
            UNIT_ASSERT_VALUES_EQUAL(NThreading::GetExceptionMessage(error), "not today");
        }
    }

    Y_UNIT_TEST(Guard) {
        NThreading::TFuture<void> f;
        {
            NThreading::TGuard g;
            f = g.GetFuture();
            UNIT_ASSERT(f.Initialized());
            UNIT_ASSERT(!f.HasException());
            UNIT_ASSERT(!f.HasValue());
        }
        UNIT_ASSERT(f.Initialized());
        UNIT_ASSERT(!f.HasException());
        UNIT_ASSERT(f.HasValue());
    }

    Y_UNIT_TEST(Initialize) {
        auto uninitialized = NThreading::TFuture<int>();
        UNIT_ASSERT(!uninitialized.Initialized());
        auto initialized = NThreading::Initialize(uninitialized);
        UNIT_ASSERT(initialized.Initialized());
        UNIT_ASSERT(!initialized.HasValue());
        UNIT_ASSERT(initialized.HasException());
        try {
            initialized.GetValue();
        } catch (const yexception& e) {
            Cerr << e.AsStrBuf() << Endl;
            UNIT_ASSERT(e.BackTrace());
            Cerr << e.BackTrace()->PrintToString() << Endl;
        }
    }
}
