#include "meta.h"

#include <library/cpp/logger/global/global.h>

TMap<TString, NDrive::IRequester::TCar> NDrive::TMetaRequester::GetCars(TConstArrayRef<TString> ids) const {
    TMap<TString, NDrive::IRequester::TCar> result;
    for (size_t i = 0; i < Requesters.size(); ++i) {
        auto requester = Requesters[i];
        Y_ENSURE(requester);
        auto subresult = requester->GetCars(ids);
        for (auto&& [id, car] : subresult) {
            if (!car.IMEI) {
                continue;
            }

            car.Index = i;
            if (!result.emplace(id, std::move(car)).second) {
                WARNING_LOG << id << " is duplicated in MetaRequester" << Endl;
            }
        }
    }
    return result;
}

TMap<ui64, NDrive::IRequester::TCar> NDrive::TMetaRequester::GetCars(TConstArrayRef<ui64> imeis) const {
    TMap<ui64, NDrive::IRequester::TCar> result;
    for (size_t i = 0; i < Requesters.size(); ++i) {
        auto requester = Requesters[i];
        Y_ENSURE(requester);
        auto subresult = requester->GetCars(imeis);
        for (auto&& [imei, car] : subresult) {
            if (!car.IMEI) {
                continue;
            }

            car.Index = i;
            if (!result.emplace(imei, std::move(car)).second) {
                WARNING_LOG << imei << " is duplicated in MetaRequester" << Endl;
            }
        }
    }
    return result;
}

TVector<NDrive::TStatus> NDrive::TMetaRequester::GetDelta(TInstant from, TInstant to, TConstArrayRef<TCar> cars, bool reportActiveSessions) const {
    TVector<NDrive::TStatus> result;
    for (size_t i = 0; i < Requesters.size(); ++i) {
        auto requester = Requesters[i];
        Y_ENSURE(requester);

        TVector<TCar> filteredCars;
        for (auto&& car : cars) {
            if (car.Index == i) {
                filteredCars.push_back(car);
            }
        }
        if (filteredCars.empty() && !cars.empty()) {
            continue;
        }

        auto subresult = requester->GetDelta(from, to, filteredCars, reportActiveSessions);
        for (auto&& status : subresult) {
            status.SetIndex(i);
            result.push_back(std::move(status));
        }
    }
    return result;
}
