#pragma once

#include "requester.h"

namespace NDrive {
    class TMetaRequester: public IRequester {
    public:
        TMetaRequester(TVector<TRequesterPtr>&& requesters)
            : Requesters(std::move(requesters))
        {
        }

        TMap<TString, TCar> GetCars(TConstArrayRef<TString> ids) const override;
        TMap<ui64, TCar> GetCars(TConstArrayRef<ui64> imeis) const override;
        TVector<TStatus> GetDelta(TInstant from, TInstant to, TConstArrayRef<TCar> cars = {}, bool reportActiveSessions = false) const override;

    private:
        TVector<TRequesterPtr> Requesters;
    };
}
