#include "timeline.h"
#include "meta.h"

#include <rtline/util/algorithm/container.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TimelineSuite) {
    Y_UNIT_TEST(Load) {
        auto host = TString("prestable.carsharing.yandex.net");
        auto extraCgi = TString();
        auto token = GetEnv("DRIVE_TOKEN");
        UNIT_ASSERT(token);
        auto requester = MakeAtomicShared<NDrive::TSessionRequester>(host, extraCgi, token);
        //requester->SetTagFilter("-total_car*-returned_car*-fake_car*-total_for_sale");
        requester->SetTrackedTags({
            "parking_free",
            "kazan_tag",
            "spb_tag",
        });

        auto leasing = MakeAtomicShared<NDrive::TSessionRequester>("leasing-cabinet.carsharing.yandex.net", TString{}, token);

        TVector<NDrive::TRequesterPtr> requesters = {
            requester,
            leasing,
        };
        auto meta = MakeAtomicShared<NDrive::TMetaRequester>(std::move(requesters));
        NDrive::TNewTimelines timelines(meta);
        UNIT_ASSERT(timelines.GetCount() > 0);
        auto cars = timelines.GetCars();
        TSet<TString> tags;
        for (auto&& car : cars) {
            for (auto&& tag : car.Tags) {
                UNIT_ASSERT(tag.Id);
                UNIT_ASSERT(tag.Name);
                tags.insert(tag.Name);
            }
            auto servicePerformers = car.GetServicePerformers();
            auto timeline = timelines.GetTimeline(car.IMEI);
            UNIT_ASSERT(timeline);
            if (!servicePerformers.empty()) {
                auto currentStatus = timeline->GetCurrentStatus();
                if (servicePerformers.contains(currentStatus.GetUserId())) {
                    INFO_LOG << "car " << car.Id << " is driven by a serviceman " << currentStatus.GetUserId() << Endl;
                }
            }
        }
        UNIT_ASSERT(tags.size() > 0);
        for (auto&& tag : tags) {
            NOTICE_LOG << tag << Endl;
        }
        for (size_t i = 0; i < 100; ++i) {
            timelines.GetTimeline(cars.at(i).IMEI);
            Sleep(TDuration::Seconds(1));
        }
        INFO_LOG << timelines.GetCount() << Endl;
    }
}
