#include "interface.h"

NThreading::TFuture<NDrive::TTrack> NDrive::ITrackClient::GetTail(const TTailQuery& query, TInstant deadline) const {
    NDrive::TTrackQuery trackQuery;
    trackQuery.DeviceId = query.DeviceId;
    trackQuery.IMEI = query.IMEI;
    trackQuery.NumDoc = query.CurrentNumDoc;
    auto tracks = GetTracks(trackQuery, deadline - Now());
    auto result = tracks.Apply([query, deadline, this](const NThreading::TFuture<NDrive::TTracks>& tracks) {
        auto optionalTail = NDrive::GetTail(tracks.GetValue(), query.Length);
        Y_ENSURE(optionalTail, "cannot GetTail from " << tracks.GetValue().size() << " tracks");
        auto tail = std::move(*optionalTail);
        auto length = NDrive::CalcLength(tail);
        if (length < query.Length) {
            auto q = query;
            q.CurrentNumDoc *= 2;
            if (q.CurrentNumDoc <= q.MaximumNumDoc && Now() < deadline) {
                return GetTail(q, deadline);
            }
        }
        return NThreading::MakeFuture(std::move(tail));
    });
    return result;
}

NThreading::TFuture<NDrive::TTracks> NDrive::TTrackClientRef::GetTracks(const TTrackQuery& query, TDuration timeout) const {
    return Yensured(Client)->GetTracks(query, timeout);
}
