#pragma once

#include "query.h"
#include "track.h"

#include <library/cpp/threading/future/future.h>

namespace NDrive {
    class ITrackClient {
    public:
        virtual ~ITrackClient() = default;

        virtual NThreading::TFuture<TTracks> GetTracks(const TTrackQuery& query, TDuration timeout) const = 0;
        virtual NThreading::TFuture<TTrack> GetTail(const TTailQuery& query, TInstant deadline) const;
    };
    using TTrackClientPtr = TAtomicSharedPtr<ITrackClient>;

    class TTrackClientRef final: public ITrackClient {
    public:
        TTrackClientRef(const ITrackClient* client)
            : Client(client)
        {
        }

        NThreading::TFuture<TTracks> GetTracks(const TTrackQuery& query, TDuration timeout) const override;

    private:
        const ITrackClient* Client;
    };
}
