#pragma once

#include "client.h"

#include <rtline/api/graph/router/router.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/library/geometry/polyline.h>

namespace NDrive {

    class TTrackProjector {
    private:
        using TSegment = std::pair<TInstant, TPolyLine<TGeoCoord>>;

        TVector<NGraph::TTimedGeoCoordinate> Coordinates;

    public:
        TTrackProjector(const NDrive::TTracksLinker::TResults& results);

        TGeoCoord Project(const TGeoCoord& coord, TInstant ts, TDuration delta = TDuration::Seconds(30)) const;
    };

}
