#include "projector.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TracksProjectorSuite) {
    Y_UNIT_TEST(Project) {
        NDrive::TTracksLinker::TSegment segment;
        segment.Coordinates = {
            {{27.606573, 53.949475}, TInstant::Seconds(1624294450)},
            {{27.610950, 53.949657}, TInstant::Seconds(1624294470)}
        };
        NDrive::TTracksLinker::TResult result;
        result.Segments.push_back(segment);
        NDrive::TTracksLinker::TResults results{result};
        NDrive::TTrackProjector projector(results);
        TGeoCoord projected = projector.Project(TGeoCoord(27.606943, 53.94902), TInstant::Seconds(1624294457));
        TGeoCoord valid(27.60688681, 53.94948805);
        UNIT_ASSERT_DOUBLES_EQUAL(projected.GetLengthTo(valid), 0, 1e-3);
    }
    Y_UNIT_TEST(ProjectProcessed) {
        TSpeedLimitRange range;
        range.Points = {
            {27.606573, 53.949475},
            {27.610950, 53.949657}
        };
        NDrive::TTracksLinker::TSegment segment;
        segment.Coordinates = {
            {{27.606573, 53.949475}, TInstant::Seconds(1624294450)},
            {{27.610950, 53.949657}, TInstant::Seconds(1624294470)}
        };
        segment.Processed.push_back(range);
        NDrive::TTracksLinker::TResult result;
        result.Segments.push_back(segment);
        NDrive::TTracksLinker::TResults results{result};
        NDrive::TTrackProjector projector(results);
        TGeoCoord projected = projector.Project(TGeoCoord(27.606943, 53.94902), TInstant::Seconds(1624294457));
        TGeoCoord valid(27.60688681, 53.94948805);
        UNIT_ASSERT_DOUBLES_EQUAL(projected.GetLengthTo(valid), 0, 1e-3);
    }
}
