#include "quality.h"

#include <rtline/api/graph/metrics/quality.h>

bool IsSpeedLimitExceeded(const NDrive::TTracksLinker::TResult& linked) {
    for (auto&& segment : linked.Segments) {
        if (IsSpeedLimitExceeded(segment.Processed)) {
            return true;
        }
    }
    return false;
}

bool IsSpeedLimitExceeded(const NDrive::TTracksLinker::TResults& linked) {
    for (auto&& i : linked) {
        if (IsSpeedLimitExceeded(i)) {
            return true;
        }
    }
    return false;
}

bool IsHardSpeedLimitExceeded(const NDrive::TTracksLinker::TResult& linked) {
    for (auto&& segment : linked.Segments) {
        for (auto&& range : segment.Processed) {
            if (range.IsHard && range.IsSpeedLimitExceeded()) {
                return true;
            }
        }
    }
    return false;
}

bool IsHardSpeedLimitExceeded(const NDrive::TTracksLinker::TResults& linked) {
    for (auto&& i : linked) {
        if (IsHardSpeedLimitExceeded(i)) {
            return true;
        }
    }
    return false;
}
