#pragma once

#include <rtline/library/json/field.h>
#include <drive/library/cpp/common/status.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NDrive {
    struct TTrackQuery {
        TString DeviceId;
        TString RideId;
        TString UserId;
        TString SessionId;
        TString IMEI;
        TDuration DurationThreshold;
        TInstant Since = TInstant::Zero();
        TInstant Until = TInstant::Max();
        ui32 NumDoc = 1000;
        TMaybe<ECarStatus> Status;

        DECLARE_FIELDS(
            Field(DeviceId, "device_id"),
            Field(RideId, "ride_id"),
            Field(UserId, "user_id"),
            Field(SessionId, "session_id"),
            Field(IMEI, "imei"),
            Field(Since, "since"),
            Field(Until, "until"),
            Field(NumDoc, "numdoc"),
            Field(Status, "status")
        );
    };

    struct TTailQuery {
        TString DeviceId;
        TString IMEI;
        double Length = 500;
        ui32 CurrentNumDoc = 10;
        ui32 MaximumNumDoc = 100;
    };
}
