#include "trace.h"

#include <drive/library/cpp/tracks/proto/trace.pb.h>

#include <rtline/library/geometry/coord.h>
#include <rtline/protos/proto_helper.h>

bool NDrive::ParseTrace(const TString& data, const TTraceParser& parser) {
    NRTLineProto::TAimTrace proto;
    if (!TSearchProtoHelper::UnpackObject(data, proto)) {
        return false;
    }

    bool atFirst = true;
    TTracePoint point;
    for (auto&& i : proto.GetPoint()) {
        if (!(!atFirst || (i.HasVFlow() && i.HasVVehicle() && i.HasVLimit() && i.HasCoord()))) {
            return false;
        }
        point.Timestamp = TInstant::Seconds(i.GetTimestamp());
        if (i.HasCoord()) {
            point.Coordinate.Deserialize(i.GetCoord());
        }
        if (i.HasExternalId()) {
            point.ExternalId = i.GetExternalId();
        }
        if (i.HasEdgeLength()) {
            point.EdgeLength = i.GetEdgeLength();
        }
        if (i.HasFlowTracksCount()) {
            point.FlowTracksCount = i.GetFlowTracksCount();
        }
        if (i.HasVFlow()) {
            point.FlowSpeed = i.GetVFlow();
        }
        if (i.HasVVehicle()) {
            point.Speed = i.GetVVehicle();
        }
        if (i.HasVLimit()) {
            point.SpeedLimit = i.GetVLimit();
        }
        parser(point);
        atFirst = false;
    }
    return true;
}
