#pragma once

#include <rtline/library/geometry/coord.h>

#include <util/datetime/base.h>

#include <functional>

namespace NDrive {
    struct TTracePoint {
        TGeoCoord Coordinate;
        TInstant Timestamp;
        double Speed = 0;
        double SpeedLimit = 0;
        double FlowSpeed = 0;
        double EdgeLength = 0;
        ui64 ExternalId = 0;
        ui32 FlowTracksCount = 0;
    };
    using TTraceParser = std::function<void(const TTracePoint&)>;

    bool ParseTrace(const TString& data, const TTraceParser& parser);
}
