#pragma once

#include <rtline/api/graph/metrics/quality.h>
#include <drive/library/cpp/common/status.h>
#include <rtline/util/types/interval.h>

namespace NDrive {
    struct TTrack {
        TString Name;
        TString DeviceId;
        TString UserId;
        TString SessionId;
        TString Source;
        NGraph::TRouter::TTimedGeoCoordinates Coordinates;
        NGraph::TRouter::TOptionalMatch Linked;
        NDrive::ECarStatus Status = NDrive::ECarStatus::csUnknown;
    };
    using TTracks = TVector<TTrack>;
    using TOptionalTrack = TMaybe<TTrack>;

    TDuration CalcDuration(const TTrack& track);
    double CalcLength(const TTrack& track);
    TTrack CropTrack(TTrack&& track, TInstant since, TInstant until);
    TTrack CropTrack(const TTrack& track, TInstant since, TInstant until);
    TOptionalTrack GetTail(const TTracks& tracks, double length);
    TOptionalTrack GetTail(const TTracks& tracks, TDuration duration);
    TOptionalTrack GetTail(const TTracks& tracks, TInstant since);

    struct TTrackPartition {
        TVector<TInterval<TInstant>> Intervals;
        TMaybe<TInterval<TInstant>> Head;
        TMaybe<TInterval<TInstant>> Tail;
    };
    struct TTrackPartitionOptions {
        TDuration Fault = TDuration::Seconds(10);
        TDuration Threshold = TDuration::Minutes(5);
        double SpeedThreshold = 1;
        bool AlwaysCutEdges = false;
        bool SkipEmpty = false;
    };

    TTrackPartition BuildSimplePartition(const TInterval<TInstant>& ridingInterval, const NDrive::TTrack& track, const TTrackPartitionOptions& options);
    TTrackPartition BuildTrackPartition(const TInterval<TInstant>& ridingInterval, const NDrive::TTrack& track, const TTrackPartitionOptions& options);
    void BuildTrackPartition(const TInterval<TInstant>& ridingInterval, const NDrive::TTrack& track, const TTrackPartitionOptions& options, TVector<TInterval<TInstant>>& result);
    TDuration GetDuration(const TTrackPartition& partition);
}
