#include "client.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/builder.h>
#include <util/system/env.h>

Y_UNIT_TEST_SUITE(TrustClientSuite) {
    TTrustClientConfig commonConfig = TTrustClientConfig::ParseFromString(
            TStringBuilder() << "Host: https://trust-payments-test.paysys.yandex.net:8028" << Endl
            << "Name: " << "test" << Endl
            << "<RequestConfig>" << Endl
            << "MaxAttempts: 1" << Endl
            << "TimeoutSendingms: 1000" << Endl
            << "</RequestConfig>" << Endl
        );

    Y_UNIT_TEST(GetPaymentMethods) {
        TTrustClient client(commonConfig);
        auto methodsF = client.GetPaymentMethods(GetEnv("TrustToken"), "4030032848");
        methodsF.Wait();
        auto methods = methodsF.GetValue();
        UNIT_ASSERT_VALUES_EQUAL(methods.size(), 2);
    }
}
