#include "logger.h"

#include <library/cpp/logger/global/global.h>
#include <library/cpp/tvmauth/client/logger.h>

namespace {
    class TGlobalTvmLogger : public NTvmAuth::ILogger {
        void Log(int lvl, const TString& msg) override {
            TEMPLATE_LOG(static_cast<ELogPriority>(lvl)) << msg << Endl;
        }
    };
}

TIntrusivePtr<NTvmAuth::ILogger> CreateGlobalTvmLogger() {
    return MakeIntrusive<TGlobalTvmLogger>();
}
