#pragma once

#include "user_features.h"
#include "realtime_user_data.h"
#include "user_requests_history.h"

#include <library/cpp/threading/future/future.h>
#include <library/cpp/yconf/conf.h>

class TRTLineAPIConfig;

namespace NRTLine {
    class TNehSearchClient;
}

namespace NDrive {
    class TUserEventsApiConfig {
        R_READONLY(TString, KVRTLineApiName);
        R_READONLY(TString, HistoryRTLineApiName);
        R_READONLY(TDuration, KVResponseTimeout, TDuration::MilliSeconds(100));
        R_READONLY(TDuration, HistoryResponseTimeout, TDuration::Seconds(5));
        R_READONLY(ui32, MaxHistoryRequestsCount, 100);

    public:
        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
    };

    class TUserEventsApi {
    private:
        const NRTLine::TNehSearchClient& KVClient;
        const NRTLine::TNehSearchClient& HistoryClient;
        R_CONST(TDuration, KVResponseTimeout);
        R_CONST(TDuration, HistoryResponseTimeout);
        R_CONST(ui32, MaxHistoryRequestsCount);

    public:
        TUserEventsApi(const TUserEventsApiConfig& config, const NRTLine::TNehSearchClient& kvClient, const NRTLine::TNehSearchClient& historyClient);

        NThreading::TFuture<TRealtimeUserData> GetRealtimeUserInfo(const TString& userId, bool fetchLocation, bool fetchClientData) const;
        NThreading::TFuture<TUserFeatures> GetUserFeatures(const TString& userId) const;
        NThreading::TFuture<TOptionalUserGeoFeatures> GetUserGeoFeatures(const TString& userId, const TGeoCoord& coordinate) const;
        NThreading::TFuture<TOptionalUserGeoFeatures> GetUserGeoFeatures(const TString& userId, ui64 geobaseId) const;
        NThreading::TFuture<TOptionalUserDoubleGeoFeatures> GetUserDoubleGeoFeatures(const TString& userId, const TGeoCoord& a, const TGeoCoord& b) const;
        NThreading::TFuture<TOptionalUserDoubleGeoFeatures> GetUserDoubleGeoFeatures(const TString& userId, ui64 geobaseIdA, ui64 geobaseIdB) const;
        NThreading::TFuture<TRequestHistoryReply> GetUserRequests(const TString& userId, TInstant since = TInstant::Zero(), TInstant until = TInstant::Max(), ui32 pageIndex = 0) const;
        NThreading::TFuture<TUserDestinationSuggest> GetUserDestinationSuggest(const TString& userId, bool fetchGeoFeatures = true) const;
    };
}  // namespace NDrive
