#include "client.h"

#include <drive/library/cpp/threading/future.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/api/search_client/neh_client.h>

namespace {
    bool IsGood(TStringBuf value) {
        return !value.empty();
    }
    bool IsGood(double value) {
        return value > -2;
    }
}

Y_UNIT_TEST_SUITE(UserEventsApi) {
    Y_UNIT_TEST(Features) {
        NRTLine::TNehSearchClient driveCacheClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NRTLine::TNehSearchClient driveSearchClient("drive_search", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TUserEventsApiConfig config;
        NDrive::TUserEventsApi api(config, driveCacheClient, driveSearchClient);

        TString userId = "636bad06-05e7-4f7c-8eda-08cd972aafd4";
        auto asyncFeatures = api.GetUserFeatures(userId);
        UNIT_ASSERT(asyncFeatures.Initialized());
        auto features = asyncFeatures.GetValueSync();

        ui64 goodCatCount = 0;
        for (auto&& i : features.CatFactors2) {
            Cerr << i << Endl;
            if (i && !i->empty()) {
                ++goodCatCount;
            }
        }
        UNIT_ASSERT(goodCatCount > 0);

        ui64 goodFloatCount = 0;
        for (auto&& i : features.Factors) {
            Cerr << i << Endl;
            if (i) {
                ++goodFloatCount;
            }
        }
        UNIT_ASSERT(goodFloatCount > 5);
    }

    Y_UNIT_TEST(GeoFeatures) {
        NRTLine::TNehSearchClient driveCacheClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NRTLine::TNehSearchClient driveSearchClient("drive_search", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TUserEventsApiConfig config;
        NDrive::TUserEventsApi api(config, driveCacheClient, driveSearchClient);

        TString userId = "00000451-1730-4e51-8ad7-4a14c58f36a6";
        TGeoCoord coordinate = { 37.601, 55.811 };
        auto asyncFeatures = api.GetUserGeoFeatures(userId, coordinate);
        UNIT_ASSERT(asyncFeatures.Initialized());
        auto features = asyncFeatures.GetValueSync();
        UNIT_ASSERT(features);
        UNIT_ASSERT_VALUES_EQUAL(features->A.GeoId, "geo:5581_3760:features");
        ui64 goodCount = 0;
        ForEach(features->GetFields(), [&goodCount](auto&& field) {
            Cerr << field.GetName() << '=' << field.Value << Endl;
            if (IsGood(field.Value)) {
                ++goodCount;
            }
        });
        UNIT_ASSERT(goodCount > 10);
    }

    Y_UNIT_TEST(Suggest) {
        NRTLine::TNehSearchClient driveCacheClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NRTLine::TNehSearchClient driveSearchClient("drive_search", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TUserEventsApiConfig config;
        NDrive::TUserEventsApi api(config, driveCacheClient, driveSearchClient);

        TString userId = "00000451-1730-4e51-8ad7-4a14c58f36a6";
        auto asyncSuggest = api.GetUserDestinationSuggest(userId);
        UNIT_ASSERT(asyncSuggest.Initialized());
        auto suggest = asyncSuggest.ExtractValueSync();
        UNIT_ASSERT(!suggest.Elements.empty());
        for (auto&& element : suggest.Elements) {
            UNIT_ASSERT(element.Latitude > 0);
            UNIT_ASSERT(element.Longitude > 0);
            UNIT_ASSERT(element.UserGeoFeatures.Initialized());
        }
    }
}
