#include "realtime_user_data.h"

#include <search/idl/meta.pb.h>

namespace NDrive {
    NJson::TJsonValue TRealtimeUserData::SerializeToJson() const {
        NJson::TJsonValue res(NJson::JSON_MAP);
        if (LocationInitialized()) {
            res["latitude"] = Location.Y;
            res["longitude"] = Location.X;
            res["last_location_update"] = LastLocationUpdate.Seconds();
        }

        if (ClientAppDataInitialized()) {
            res["user_agent"] = UserAgent;
            res["ip"] = Ip;
            res["host"] = Host;
            res["device_id"] = DeviceId;
            res["app_version"] = AppVersion;
            TJsonProcessor::WriteContainerArray(res, "experiments", Experiments);
            res["last_data_update"] = LastDataUpdate.Seconds();
        }
        return res;
    }

    bool TRealtimeUserData::LocationInitialized() const {
        return LastLocationUpdate != TInstant::Zero();
    }

    bool TRealtimeUserData::ClientAppDataInitialized() const {
        return LastDataUpdate != TInstant::Zero();
    }

    void TRealtimeUserData::FillFromLocationDocument(const NMetaProtocol::TDocument& document) {
        for (auto&& property : document.GetArchiveInfo().GetGtaRelatedAttribute()) {
            const auto& key = property.GetKey();
            const auto& value = property.GetValue();
            if (key == "Timestamp") {
                LastLocationUpdate = TInstant::Seconds(FromString<ui64>(value));
            } else if (key == "Latitude") {
                Location.Y = FromString<double>(value);
            } else if (key == "Longitude") {
                Location.X = FromString<double>(value);
            }
        }
    }

    void TRealtimeUserData::FillFromDataDocument(const NMetaProtocol::TDocument& document) {
        for (auto&& property : document.GetArchiveInfo().GetGtaRelatedAttribute()) {
            const auto& key = property.GetKey();
            const auto& value = property.GetValue();
            if (key == "Timestamp") {
                LastDataUpdate = TInstant::Seconds(FromString<ui64>(value));
            } else if (key == "Ip") {
                Ip = value;
            } else if (key == "Host") {
                Host = value;
            } else if (key == "UserAgent") {
                UserAgent = value;
            } else if (key == "AppVersion") {
                AppVersion = value;
            } else if (key == "DeviceID") {
                DeviceId = value;
            } else if (key == "Experiments") {
                StringSplitter(value).Split(',').ParseInto(&Experiments);
            }
        }
    }
}  // namespace NDrive
