#pragma once

#include <library/cpp/json/json_value.h>

#include <rtline/library/geometry/coord.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/string.h>

namespace NMetaProtocol {
    class TDocument;
}

namespace NDrive {
    class TRealtimeUserData {
        R_READONLY(TGeoCoord, Location);
        R_READONLY(TInstant, LastLocationUpdate);

        R_READONLY(TString, UserAgent);
        R_READONLY(TString, Ip);
        R_READONLY(TString, Host);
        R_READONLY(TString, DeviceId);
        R_READONLY(TString, AppVersion);
        R_READONLY(TVector<ui32>, Experiments);
        R_READONLY(TInstant, LastDataUpdate);

    public:
        bool LocationInitialized() const;
        bool ClientAppDataInitialized() const;
        NJson::TJsonValue SerializeToJson() const;

        void FillFromLocationDocument(const NMetaProtocol::TDocument& document);
        void FillFromDataDocument(const NMetaProtocol::TDocument& document);
    };
}  // namespace NDrive
