#include "user_features.h"

#include <drive/backend/offers/factors/factors_info.h>
#include <drive/library/cpp/threading/future.h>
#include <drive/library/cpp/threading/future_cast.h>

#include <rtline/library/geometry/coord.h>
#include <rtline/library/json/builder.h>
#include <rtline/library/json/cast.h>

DECLARE_FIELDS_JSON_SERIALIZER(NDrive::TUserFeatures);
DECLARE_FIELDS_JSON_SERIALIZER(NDrive::TUserGeoFeatures);
DECLARE_FIELDS_JSON_SERIALIZER(NDrive::TUserDoubleGeoFeatures);

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TUserDestinationSuggest::TElement& object) {
    NJson::TJsonValue result;
    result["coordinate"] = NJson::ToJson(TGeoCoord{object.Longitude, object.Latitude});
    result["score"] = NJson::ToJson(object.Score);
    result["user_geo_features"] = NJson::ToJson(object.UserGeoFeatures);
    return result;
}

NJson::TJsonValue NDrive::TUserFeatures::GetReport() const {
    NJson::TJsonValue result = NJson::JSON_MAP;
    {
        const IFactorsInfo* catFactorsInfo2 = NDrive::GetCatOfferFactorsInfo2();
        NJson::TJsonValue catFactors = NJson::JSON_MAP;
        for (size_t i = 0; i < std::min(CatFactors2.size(), catFactorsInfo2->GetFactorCount()); i++) {
            if (CatFactors2[i]) {
                catFactors[catFactorsInfo2->GetFactorName(i)] = *CatFactors2[i];
            }
        }
        result["cat_factors"] = std::move(catFactors);
    }
    {
        const IFactorsInfo* factorsInfo2 = NDrive::GetOfferFactorsInfo2();
        NJson::TJsonValue factors = NJson::JSON_MAP;
        for (size_t i = 0; i < std::min(Factors2.size(), factorsInfo2->GetFactorCount()); i++) {
            if (Factors2[i]) {
                factors[factorsInfo2->GetFactorName(i)] = *Factors2[i];
            }
        }
        result["factors"] = std::move(factors);
    }
    return result;
}
