#pragma once

#include <rtline/library/json/field.h>

#include <library/cpp/threading/future/future.h>

#include <util/generic/maybe.h>
#include <util/generic/set.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDrive {
    constexpr double UserFeaturesDefaultValue = -2;

    struct TUserFeatures {
        float AverageSessionCarsCount = 0;
        float AverageSessionClicksCount = 0;
        TSet<TString> InstalledApps;

        TVector<TMaybe<float>> Factors;

        TVector<TMaybe<TString>> CatFactors2;
        TVector<TMaybe<float>> Factors2;

        bool Defined = false;

        DECLARE_FIELDS(
            Field(AverageSessionCarsCount, "average_session_cars_count"),
            Field(AverageSessionClicksCount, "average_session_clicks_count"),
            Field(InstalledApps, "installed_apps"),
            Field(Defined, "defined"),
            Field(Factors, "factors"),
            Field(CatFactors2, "cat_factors_2"),
            Field(Factors2, "factors_2")
        );

        NJson::TJsonValue GetReport() const;
    };

    struct TGeoEndpointFeatures {
        TString GeoId;
        double Freq = UserFeaturesDefaultValue;
        double Ratio = UserFeaturesDefaultValue;
        double InTop = UserFeaturesDefaultValue;
        double Dur10Freq = UserFeaturesDefaultValue;
        double Dur1020Freq = UserFeaturesDefaultValue;
        double Dur2040Freq = UserFeaturesDefaultValue;
        double Dur40Freq = UserFeaturesDefaultValue;
        double MorningFreq = UserFeaturesDefaultValue;
        double DayFreq = UserFeaturesDefaultValue;
        double EveningFreq = UserFeaturesDefaultValue;
        TString Top1GeoId;
        double Top1Dist = UserFeaturesDefaultValue;
        double Top1Freq = UserFeaturesDefaultValue;
        double Top1Ratio = UserFeaturesDefaultValue;
        TString Top2GeoId;
        double Top2Dist = UserFeaturesDefaultValue;
        double Top2Freq = UserFeaturesDefaultValue;
        double Top2Ratio = UserFeaturesDefaultValue;

        // freq: (all,morning,day,evening,weekday,weekend) * (weighted,uniform) == 12 features
        double GeobaseFreq = UserFeaturesDefaultValue;
        double GeobaseMorningFreq = UserFeaturesDefaultValue;
        double GeobaseDayFreq = UserFeaturesDefaultValue;
        double GeobaseEveningFreq = UserFeaturesDefaultValue;
        double GeobaseWeekendFreq = UserFeaturesDefaultValue;
        double GeobaseWeekdayFreq = UserFeaturesDefaultValue;

        double GeobaseWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseDayWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseWeekendWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseWeekdayWeightedFreq = UserFeaturesDefaultValue;

        // ratio: (all,morning,day,evening,weekday,weekend) * (weighted,uniform) == 12 features
        double GeobaseRatio = UserFeaturesDefaultValue;
        double GeobaseMorningRatio = UserFeaturesDefaultValue;
        double GeobaseDayRatio = UserFeaturesDefaultValue;
        double GeobaseEveningRatio = UserFeaturesDefaultValue;
        double GeobaseWeekendRatio = UserFeaturesDefaultValue;
        double GeobaseWeekdayRatio = UserFeaturesDefaultValue;

        double GeobaseWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseDayWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseWeekendWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseWeekdayWeightedRatio = UserFeaturesDefaultValue;

        // pct: (all,morning,day,evening,weekday,weekend) == 6 features
        double GeobasePct = UserFeaturesDefaultValue;
        double GeobaseMorningPct = UserFeaturesDefaultValue;
        double GeobaseDayPct = UserFeaturesDefaultValue;
        double GeobaseEveningPct = UserFeaturesDefaultValue;
        double GeobaseWeekendPct = UserFeaturesDefaultValue;
        double GeobaseWeekdayPct = UserFeaturesDefaultValue;

        // geosame: only for A
        double GeobaseSame = UserFeaturesDefaultValue;
    };

    struct TUserGeoFeatures {
        TGeoEndpointFeatures A;
        TGeoEndpointFeatures B;

        DECLARE_FIELDS(
            Field(A.GeoId, "FI_GEO_ID_A"),
            Field(A.Freq, "GEO_A_FREQ"),
            Field(A.Ratio, "GEO_A_RATIO"),
            Field(A.InTop, "GEO_A_IN_TOP"),
            Field(A.Dur10Freq, "GEO_A_DUR_10_FREQ"),
            Field(A.Dur1020Freq, "GEO_A_DUR_10_20_FREQ"),
            Field(A.Dur2040Freq, "GEO_A_DUR_20_40_FREQ"),
            Field(A.Dur40Freq, "GEO_A_DUR_40_FREQ"),
            Field(A.MorningFreq, "GEO_A_MORNING_FREQ"),
            Field(A.DayFreq, "GEO_A_DAY_FREQ"),
            Field(A.EveningFreq, "GEO_A_EVENING_FREQ"),
            Field(A.Top1GeoId, "GEO_A_TO_TOP1_B"),
            Field(A.Top1Freq, "GEO_A_TO_TOP1_B_FREQ"),
            Field(A.Top1Ratio, "GEO_A_TO_TOP1_B_RATIO"),
            Field(A.Top1Dist, "GEO_A_TO_TOP1_B_DIST"),
            Field(A.Top2GeoId, "GEO_A_TO_TOP2_B"),
            Field(A.Top2Freq, "GEO_A_TO_TOP2_B_FREQ"),
            Field(A.Top2Ratio, "GEO_A_TO_TOP2_B_RATIO"),
            Field(A.Top2Dist, "GEO_A_TO_TOP2_B_DIST"),

            Field(A.GeobaseFreq, "GEOBASE_A_FREQ"),
            Field(A.GeobaseMorningFreq, "GEOBASE_A_MORNING_FREQ"),
            Field(A.GeobaseDayFreq, "GEOBASE_A_DAY_FREQ"),
            Field(A.GeobaseEveningFreq, "GEOBASE_A_EVENING_FREQ"),
            Field(A.GeobaseWeekendFreq, "GEOBASE_A_WEEKEND_FREQ"),
            Field(A.GeobaseWeekdayFreq, "GEOBASE_A_WEEKDAY_FREQ"),

            Field(A.GeobaseWeightedFreq, "GEOBASE_A_WEIGHTED_FREQ"),
            Field(A.GeobaseMorningWeightedFreq, "GEOBASE_A_MORNING_WEIGHTED_FREQ"),
            Field(A.GeobaseDayWeightedFreq, "GEOBASE_A_DAY_WEIGHTED_FREQ"),
            Field(A.GeobaseEveningWeightedFreq, "GEOBASE_A_EVENING_WEIGHTED_FREQ"),
            Field(A.GeobaseWeekendWeightedFreq, "GEOBASE_A_WEEKEND_WEIGHTED_FREQ"),
            Field(A.GeobaseWeekdayWeightedFreq, "GEOBASE_A_WEEKDAY_WEIGHTED_FREQ"),

            Field(A.GeobaseRatio, "GEOBASE_A_RATIO"),
            Field(A.GeobaseMorningRatio, "GEOBASE_A_MORNING_RATIO"),
            Field(A.GeobaseDayRatio, "GEOBASE_A_DAY_RATIO"),
            Field(A.GeobaseEveningRatio, "GEOBASE_A_EVENING_RATIO"),
            Field(A.GeobaseWeekendRatio, "GEOBASE_A_WEEKEND_RATIO"),
            Field(A.GeobaseWeekdayRatio, "GEOBASE_A_WEEKDAY_RATIO"),

            Field(A.GeobaseWeightedRatio, "GEOBASE_A_WEIGHTED_RATIO"),
            Field(A.GeobaseMorningWeightedRatio, "GEOBASE_A_MORNING_WEIGHTED_RATIO"),
            Field(A.GeobaseDayWeightedRatio, "GEOBASE_A_DAY_WEIGHTED_RATIO"),
            Field(A.GeobaseEveningWeightedRatio, "GEOBASE_A_EVENING_WEIGHTED_RATIO"),
            Field(A.GeobaseWeekendWeightedRatio, "GEOBASE_A_WEEKEND_WEIGHTED_RATIO"),
            Field(A.GeobaseWeekdayWeightedRatio, "GEOBASE_A_WEEKDAY_WEIGHTED_RATIO"),

            Field(A.GeobasePct, "GEOBASE_A_PCT"),
            Field(A.GeobaseMorningPct, "GEOBASE_A_MORNING_PCT"),
            Field(A.GeobaseDayPct, "GEOBASE_A_DAY_PCT"),
            Field(A.GeobaseEveningPct, "GEOBASE_A_EVENING_PCT"),
            Field(A.GeobaseWeekendPct, "GEOBASE_A_WEEKEND_PCT"),
            Field(A.GeobaseWeekdayPct, "GEOBASE_A_WEEKDAY_PCT"),

            Field(A.GeobaseSame, "GEO_SAME"),

            Field(B.GeoId, "FI_GEO_ID_B"),
            Field(B.Freq, "GEO_B_FREQ"),
            Field(B.Ratio, "GEO_B_RATIO"),
            Field(B.InTop, "GEO_B_IN_TOP"),
            Field(B.Dur10Freq, "GEO_B_DUR_10_FREQ"),
            Field(B.Dur1020Freq, "GEO_B_DUR_10_20_FREQ"),
            Field(B.Dur2040Freq, "GEO_B_DUR_20_40_FREQ"),
            Field(B.Dur40Freq, "GEO_B_DUR_40_FREQ"),
            Field(B.MorningFreq, "GEO_B_MORNING_FREQ"),
            Field(B.DayFreq, "GEO_B_DAY_FREQ"),
            Field(B.EveningFreq, "GEO_B_EVENING_FREQ"),
            Field(B.Top1GeoId, "GEO_TOP1_A_TO_B"),
            Field(B.Top1Freq, "GEO_TOP1_A_TO_B_FREQ"),
            Field(B.Top1Ratio, "GEO_TOP1_A_TO_B_RATIO"),
            Field(B.Top1Dist, "GEO_TOP1_A_TO_B_DIST"),
            Field(B.Top2GeoId, "GEO_TOP2_A_TO_B"),
            Field(B.Top2Freq, "GEO_TOP2_A_TO_B_FREQ"),
            Field(B.Top2Ratio, "GEO_TOP2_A_TO_B_RATIO"),
            Field(B.Top2Dist, "GEO_TOP2_A_TO_B_DIST"),

            Field(B.GeobaseFreq, "GEOBASE_B_FREQ"),
            Field(B.GeobaseMorningFreq, "GEOBASE_B_MORNING_FREQ"),
            Field(B.GeobaseDayFreq, "GEOBASE_B_DAY_FREQ"),
            Field(B.GeobaseEveningFreq, "GEOBASE_B_EVENING_FREQ"),
            Field(B.GeobaseWeekendFreq, "GEOBASE_B_WEEKEND_FREQ"),
            Field(B.GeobaseWeekdayFreq, "GEOBASE_B_WEEKDAY_FREQ"),

            Field(B.GeobaseWeightedFreq, "GEOBASE_B_WEIGHTED_FREQ"),
            Field(B.GeobaseMorningWeightedFreq, "GEOBASE_B_MORNING_WEIGHTED_FREQ"),
            Field(B.GeobaseDayWeightedFreq, "GEOBASE_B_DAY_WEIGHTED_FREQ"),
            Field(B.GeobaseEveningWeightedFreq, "GEOBASE_B_EVENING_WEIGHTED_FREQ"),
            Field(B.GeobaseWeekendWeightedFreq, "GEOBASE_B_WEEKEND_WEIGHTED_FREQ"),
            Field(B.GeobaseWeekdayWeightedFreq, "GEOBASE_B_WEEKDAY_WEIGHTED_FREQ"),

            Field(B.GeobaseRatio, "GEOBASE_B_RATIO"),
            Field(B.GeobaseMorningRatio, "GEOBASE_B_MORNING_RATIO"),
            Field(B.GeobaseDayRatio, "GEOBASE_B_DAY_RATIO"),
            Field(B.GeobaseEveningRatio, "GEOBASE_B_EVENING_RATIO"),
            Field(B.GeobaseWeekendRatio, "GEOBASE_B_WEEKEND_RATIO"),
            Field(B.GeobaseWeekdayRatio, "GEOBASE_B_WEEKDAY_RATIO"),

            Field(B.GeobaseWeightedRatio, "GEOBASE_B_WEIGHTED_RATIO"),
            Field(B.GeobaseMorningWeightedRatio, "GEOBASE_B_MORNING_WEIGHTED_RATIO"),
            Field(B.GeobaseDayWeightedRatio, "GEOBASE_B_DAY_WEIGHTED_RATIO"),
            Field(B.GeobaseEveningWeightedRatio, "GEOBASE_B_EVENING_WEIGHTED_RATIO"),
            Field(B.GeobaseWeekendWeightedRatio, "GEOBASE_B_WEEKEND_WEIGHTED_RATIO"),
            Field(B.GeobaseWeekdayWeightedRatio, "GEOBASE_B_WEEKDAY_WEIGHTED_RATIO"),

            Field(B.GeobasePct, "GEOBASE_B_PCT"),
            Field(B.GeobaseMorningPct, "GEOBASE_B_MORNING_PCT"),
            Field(B.GeobaseDayPct, "GEOBASE_B_DAY_PCT"),
            Field(B.GeobaseEveningPct, "GEOBASE_B_EVENING_PCT"),
            Field(B.GeobaseWeekendPct, "GEOBASE_B_WEEKEND_PCT"),
            Field(B.GeobaseWeekdayPct, "GEOBASE_B_WEEKDAY_PCT")
        );
    };
    using TOptionalUserGeoFeatures = TMaybe<TUserGeoFeatures>;

    struct TUserDoubleGeoFeatures {
        TString GeoIdA;
        TString GeoIdB;

        double Freq = UserFeaturesDefaultValue;
        double Ratio = UserFeaturesDefaultValue;
        double InTop = UserFeaturesDefaultValue;
        double Dist = UserFeaturesDefaultValue;
        double Dur10Freq = UserFeaturesDefaultValue;
        double Dur1020Freq = UserFeaturesDefaultValue;
        double Dur2040Freq = UserFeaturesDefaultValue;
        double Dur40Freq = UserFeaturesDefaultValue;
        double MorningFreq = UserFeaturesDefaultValue;
        double DayFreq = UserFeaturesDefaultValue;
        double EveningFreq = UserFeaturesDefaultValue;

        // freq: (all,morning,day,evening) x (toA,toAll) x (weighted,uniform) == 16 features
        double GeobaseFreq = UserFeaturesDefaultValue;
        double GeobaseMorningFreq = UserFeaturesDefaultValue;
        double GeobaseDayFreq = UserFeaturesDefaultValue;
        double GeobaseEveningFreq = UserFeaturesDefaultValue;

        double GeobaseFreqToA = UserFeaturesDefaultValue;
        double GeobaseMorningFreqToA = UserFeaturesDefaultValue;
        double GeobaseDayFreqToA = UserFeaturesDefaultValue;
        double GeobaseEveningFreqToA = UserFeaturesDefaultValue;

        double GeobaseWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseDayWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedFreq = UserFeaturesDefaultValue;

        double GeobaseWeightedFreqToA = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedFreqToA = UserFeaturesDefaultValue;
        double GeobaseDayWeightedFreqToA = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedFreqToA = UserFeaturesDefaultValue;

        // freq: (weekend,weekday) * (weighted,uniform) == 4 features
        double GeobaseWeekendFreq = UserFeaturesDefaultValue;
        double GeobaseWeekdayFreq = UserFeaturesDefaultValue;
        double GeobaseWeekendWeightedFreq = UserFeaturesDefaultValue;
        double GeobaseWeekdayWeightedFreq = UserFeaturesDefaultValue;

        // ratio: (all,morning,day,evening) x (toA,toAll) x (weighted,uniform) == 16 features
        double GeobaseRatio = UserFeaturesDefaultValue;
        double GeobaseMorningRatio = UserFeaturesDefaultValue;
        double GeobaseDayRatio = UserFeaturesDefaultValue;
        double GeobaseEveningRatio = UserFeaturesDefaultValue;

        double GeobaseRatioToA = UserFeaturesDefaultValue;
        double GeobaseMorningRatioToA = UserFeaturesDefaultValue;
        double GeobaseDayRatioToA = UserFeaturesDefaultValue;
        double GeobaseEveningRatioToA = UserFeaturesDefaultValue;

        double GeobaseWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseDayWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedRatio = UserFeaturesDefaultValue;

        double GeobaseWeightedRatioToA = UserFeaturesDefaultValue;
        double GeobaseMorningWeightedRatioToA = UserFeaturesDefaultValue;
        double GeobaseDayWeightedRatioToA = UserFeaturesDefaultValue;
        double GeobaseEveningWeightedRatioToA = UserFeaturesDefaultValue;

        // ratio: (weekend,weekday) * (weighted,uniform) == 4 features
        double GeobaseWeekendRatio = UserFeaturesDefaultValue;
        double GeobaseWeekdayRatio = UserFeaturesDefaultValue;
        double GeobaseWeekendWeightedRatio = UserFeaturesDefaultValue;
        double GeobaseWeekdayWeightedRatio = UserFeaturesDefaultValue;

        // pct: (all,morning,day,evening) x (toA, toAll) == 8 features
        double GeobasePct = UserFeaturesDefaultValue;
        double GeobaseMorningPct = UserFeaturesDefaultValue;
        double GeobaseDayPct = UserFeaturesDefaultValue;
        double GeobaseEveningPct = UserFeaturesDefaultValue;

        double GeobasePctToA = UserFeaturesDefaultValue;
        double GeobaseMorningPctToA = UserFeaturesDefaultValue;
        double GeobaseDayPctToA = UserFeaturesDefaultValue;
        double GeobaseEveningPctToA = UserFeaturesDefaultValue;

        // pct: (weekday,weekend) == 2 features
        double GeobaseWeekendPct = UserFeaturesDefaultValue;
        double GeobaseWeekdayPct = UserFeaturesDefaultValue;

        DECLARE_FIELDS(
            Field(GeoIdA, "geo_id_a"),
            Field(GeoIdB, "geo_id_b"),

            Field(Freq, "GEO_A_TO_B_FREQ"),
            Field(Ratio, "GEO_A_TO_B_RATIO"),
            Field(InTop, "GEO_A_TO_B_IN_TOP"),
            Field(Dist, "GEO_A_TO_B_DIST"),
            Field(Dur10Freq, "GEO_A_TO_B_DUR_10_FREQ"),
            Field(Dur1020Freq, "GEO_A_TO_B_DUR_10_20_FREQ"),
            Field(Dur2040Freq, "GEO_A_TO_B_DUR_20_40_FREQ"),
            Field(Dur40Freq, "GEO_A_TO_B_DUR_40_FREQ"),
            Field(MorningFreq, "GEO_A_TO_B_MORNING_FREQ"),
            Field(DayFreq, "GEO_A_TO_B_DAY_FREQ"),
            Field(EveningFreq, "GEO_A_TO_B_EVENING_FREQ"),

            Field(GeobaseFreq, "GEOBASE_A_TO_B_FREQ"),
            Field(GeobaseMorningFreq, "GEOBASE_A_TO_B_MORNING_FREQ"),
            Field(GeobaseDayFreq, "GEOBASE_A_TO_B_DAY_FREQ"),
            Field(GeobaseEveningFreq, "GEOBASE_A_TO_B_EVENING_FREQ"),

            Field(GeobaseFreqToA, "GEOBASE_A_TO_B_FREQ_A"),
            Field(GeobaseMorningFreqToA, "GEOBASE_A_TO_B_MORNING_FREQ_A"),
            Field(GeobaseDayFreqToA, "GEOBASE_A_TO_B_DAY_FREQ_A"),
            Field(GeobaseEveningFreqToA, "GEOBASE_A_TO_B_EVENING_FREQ_A"),

            Field(GeobaseWeightedFreq, "GEOBASE_A_TO_B_WEIGHTED_FREQ"),
            Field(GeobaseMorningWeightedFreq, "GEOBASE_A_TO_B_MORNING_WEIGHTED_FREQ"),
            Field(GeobaseDayWeightedFreq, "GEOBASE_A_TO_B_DAY_WEIGHTED_FREQ"),
            Field(GeobaseEveningWeightedFreq, "GEOBASE_A_TO_B_EVENING_WEIGHTED_FREQ"),

            Field(GeobaseWeightedFreqToA, "GEOBASE_A_TO_B_WEIGHTED_FREQ_A"),
            Field(GeobaseMorningWeightedFreqToA, "GEOBASE_A_TO_B_MORNING_WEIGHTED_FREQ_A"),
            Field(GeobaseDayWeightedFreqToA, "GEOBASE_A_TO_B_DAY_WEIGHTED_FREQ_A"),
            Field(GeobaseEveningWeightedFreqToA, "GEOBASE_A_TO_B_EVENING_WEIGHTED_FREQ_A"),

            Field(GeobaseWeekendFreq, "GEOBASE_A_TO_B_WEEKEND_FREQ"),
            Field(GeobaseWeekdayFreq, "GEOBASE_A_TO_B_WEEKDAY_FREQ"),
            Field(GeobaseWeekendWeightedFreq, "GEOBASE_A_TO_B_WEEKEND_WEIGHTED_FREQ"),
            Field(GeobaseWeekdayWeightedFreq, "GEOBASE_A_TO_B_WEEKDAY_WEIGHTED_FREQ"),

            Field(GeobaseRatio, "GEOBASE_A_TO_B_RATIO"),
            Field(GeobaseMorningRatio, "GEOBASE_A_TO_B_MORNING_RATIO"),
            Field(GeobaseDayRatio, "GEOBASE_A_TO_B_DAY_RATIO"),
            Field(GeobaseEveningRatio, "GEOBASE_A_TO_B_EVENING_RATIO"),

            Field(GeobaseRatioToA, "GEOBASE_A_TO_B_RATIO_A"),
            Field(GeobaseMorningRatioToA, "GEOBASE_A_TO_B_MORNING_RATIO_A"),
            Field(GeobaseDayRatioToA, "GEOBASE_A_TO_B_DAY_RATIO_A"),
            Field(GeobaseEveningRatioToA, "GEOBASE_A_TO_B_EVENING_RATIO_A"),

            Field(GeobaseWeightedRatio, "GEOBASE_A_TO_B_WEIGHTED_RATIO"),
            Field(GeobaseMorningWeightedRatio, "GEOBASE_A_TO_B_MORNING_WEIGHTED_RATIO"),
            Field(GeobaseDayWeightedRatio, "GEOBASE_A_TO_B_DAY_WEIGHTED_RATIO"),
            Field(GeobaseEveningWeightedRatio, "GEOBASE_A_TO_B_EVENING_WEIGHTED_RATIO"),

            Field(GeobaseWeightedRatioToA, "GEOBASE_A_TO_B_WEIGHTED_RATIO_A"),
            Field(GeobaseMorningWeightedRatioToA, "GEOBASE_A_TO_B_MORNING_WEIGHTED_RATIO_A"),
            Field(GeobaseDayWeightedRatioToA, "GEOBASE_A_TO_B_DAY_WEIGHTED_RATIO_A"),
            Field(GeobaseEveningWeightedRatioToA, "GEOBASE_A_TO_B_EVENING_WEIGHTED_RATIO_A"),

            Field(GeobaseWeekendRatio, "GEOBASE_A_TO_B_WEEKEND_RATIO"),
            Field(GeobaseWeekdayRatio, "GEOBASE_A_TO_B_WEEKDAY_RATIO"),
            Field(GeobaseWeekendWeightedRatio, "GEOBASE_A_TO_B_WEEKEND_WEIGHTED_RATIO"),
            Field(GeobaseWeekdayWeightedRatio, "GEOBASE_A_TO_B_WEEKDAY_WEIGHTED_RATIO"),

            Field(GeobasePct, "GEOBASE_A_TO_B_PCT"),
            Field(GeobaseMorningPct, "GEOBASE_A_TO_B_MORNING_PCT"),
            Field(GeobaseDayPct, "GEOBASE_A_TO_B_DAY_PCT"),
            Field(GeobaseEveningPct, "GEOBASE_A_TO_B_EVENING_PCT"),

            Field(GeobasePctToA, "GEOBASE_A_TO_B_PCT_A"),
            Field(GeobaseMorningPctToA, "GEOBASE_A_TO_B_MORNING_PCT_A"),
            Field(GeobaseDayPctToA, "GEOBASE_A_TO_B_DAY_PCT_A"),
            Field(GeobaseEveningPctToA, "GEOBASE_A_TO_B_EVENING_PCT_A"),

            Field(GeobaseWeekendPct, "GEOBASE_A_TO_B_WEEKEND_PCT"),
            Field(GeobaseWeekdayPct, "GEOBASE_A_TO_B_WEEKDAY_PCT")
        );
    };
    using TOptionalUserDoubleGeoFeatures = TMaybe<TUserDoubleGeoFeatures>;

    struct TUserDestinationSuggest {
    public:
        struct TElement {
            double Latitude = 0;
            double Longitude = 0;

            NThreading::TFuture<TOptionalUserGeoFeatures> UserGeoFeatures;
            TMaybe<double> Score;

            explicit operator bool() const {
                return std::abs(Latitude) > 0 || std::abs(Longitude) > 0;
            }
        };
        using TElements = TVector<TElement>;

    public:
        TElements Elements;
    };
}
