#pragma once

#include <library/cpp/json/json_value.h>

#include <rtline/library/geometry/coord.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/string.h>

namespace NMetaProtocol {
    class TDocument;
}

namespace NDrive {
    class TUserRequestData {
        R_READONLY(TString, RequestId);
        R_READONLY(TGeoCoord, Location);
        R_READONLY(TString, UserAgent);
        R_READONLY(TString, Ip);
        R_READONLY(TString, DeviceId);
        R_READONLY(TString, AppVersion);
        R_READONLY(TString, Host);
        R_READONLY(TString, Source);
        R_READONLY(TInstant, Timestamp);
        R_READONLY(TString, Query);
        R_READONLY(ui16, Code, 0);
        R_READONLY(TString, Response);
        R_READONLY(TString, PostData);
        R_READONLY(TVector<ui32>, Experiments);

    public:
        static bool IsAuthorizationEvent(const TString& logEvent);
        static bool IsResponseEvent(const TString& logEvent);

        TUserRequestData(const TString& requestId);
        bool Initialized() const;
        NJson::TJsonValue SerializeToJson(bool reportLocation, bool reportClientAppData) const;

        void FillFromAuthorizationDocument(const NMetaProtocol::TDocument& document);
        void FillFromResponseDocument(const NMetaProtocol::TDocument& document);
    };

    class TRequestHistoryReply {
    public:
        R_FIELD(TVector<TUserRequestData>, Requests);
        R_FIELD(bool, Complete, true);

    public:
        NJson::TJsonValue SerializeToJson(
            bool reportLocation,
            bool reportClientAppData,
            TInstant since = TInstant::Zero(),
            TInstant until = TInstant::Max()
        ) const;
    };
}  // namespace NDrive
