#include "wait_guard.h"

TWaitGuard::~TWaitGuard() {
    WaitAllTasks();
}

void TWaitGuard::RegisterObject() {
    ++LinkedObjectsCount;
}

void TWaitGuard::UnRegisterObject() {
    TGuard<TMutex> g(Lock);
    --LinkedObjectsCount;
    CondVar.Signal();
}

bool TWaitGuard::WaitAllTasks(ui64 maxTasksCount, TInstant deadline) {
    TGuard<TMutex> g(Lock);
    return CondVar.WaitD(Lock, deadline, [this, maxTasksCount]() {
        return LinkedObjectsCount.load() <= maxTasksCount;
    });
}

ui64 TWaitGuard::PoolSize() const {
    return LinkedObjectsCount.load(std::memory_order_acquire);
}

