#pragma once

#include <util/system/types.h>
#include <util/system/condvar.h>
#include <util/system/mutex.h>

#include <atomic>

class TWaitGuard {
public:
    TWaitGuard() = default;
    virtual ~TWaitGuard();

    virtual void RegisterObject();
    virtual void UnRegisterObject();
    bool WaitAllTasks(ui64 maxTasksCount = 0, TInstant deadline = TInstant::Max());
    ui64 PoolSize() const;

private:
    TMutex Lock;
    TCondVar CondVar;
    std::atomic<ui64> LinkedObjectsCount = 0;
};
