#include "config.h"
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <util/stream/file.h>

void TWeatherAPIConfig::Init(const TYandexConfig::Section* section) {
    Host = section->GetDirectives().Value("Host", Host);
    Uri = section->GetDirectives().Value("Uri", Uri);
    Port = section->GetDirectives().Value("Port", Port);
    Https = section->GetDirectives().Value("Https", Https);
    ThreadsMC = section->GetDirectives().Value("ThreadsMC", ThreadsMC);
    ThreadsRequest = section->GetDirectives().Value("ThreadsRequest", ThreadsRequest);
    MaxInFly = section->GetDirectives().Value("MaxInFly", MaxInFly);
    AuthToken = section->GetDirectives().Value("AuthToken", AuthToken);
    AuthTokenPath = section->GetDirectives().Value("AuthTokenPath", AuthTokenPath);
    if (!AuthToken && AuthTokenPath) {
        AssertCorrectConfig(TFsPath(AuthTokenPath).Exists(), "Incorrect path for auth token: %s", AuthTokenPath.c_str());
        TFileInput fInput(AuthTokenPath);
        AuthToken = fInput.ReadAll();
    }
    AssertCorrectConfig(!!AuthToken, "Empty weather auth token");
    auto children = section->GetAllChildren();
    auto it = children.find("Reask");
    if (it != children.end()) {
        ReaskConfig.InitFromSection(it->second);
    }
}

void TWeatherAPIConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Uri: " << Uri << Endl;
    os << "Port: " << Port << Endl;
    os << "Https: " << Https << Endl;
    os << "ThreadsMC: " << ThreadsMC << Endl;
    os << "ThreadsRequest: " << ThreadsRequest << Endl;
    os << "MaxInFly: " << MaxInFly << Endl;
    if (AuthTokenPath) {
        os << "AuthTokenPath: " << AuthTokenPath << Endl;
    } else if (AuthToken) {
        os << "AuthToken: " << AuthToken << Endl;
    }
    os << "<Reask>" << Endl;
    ReaskConfig.ToString(os);
    os << "</Reask>" << Endl;
}

