#pragma once
#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/string.h>
#include <util/stream/output.h>

class TWeatherAPIConfig {
    R_FIELD(TString, Host, "ah.weather.yandex.net");
    R_FIELD(TString, Uri, "/api/v3/fact");
    R_FIELD(ui16, Port, 80);
    R_FIELD(bool, Https, false);
    R_FIELD(ui32, ThreadsMC, 1);
    R_FIELD(ui32, ThreadsRequest, 4);
    R_FIELD(ui32, MaxInFly, 500);
    R_READONLY(TString, AuthTokenPath);
    R_READONLY(TString, AuthToken);
    R_READONLY(NSimpleMeta::TConfig, ReaskConfig);
public:
    void Init(const TYandexConfig::Section* section);

    void ToString(IOutputStream& os) const;
};
