#pragma once
#include "config.h"
#include <rtline/library/async_proxy/async_delivery.h>
#include <rtline/util/network/neh.h>
#include <library/cpp/json/writer/json_value.h>
#include <rtline/util/auto_actualization.h>
#include <rtline/util/network/http_request.h>
#include <rtline/library/geometry/coord.h>

namespace NDrive::NProto {
    class TWeather;
}

enum class EWeatherPrecType {
    No = 0 /* "n" */,
    Rain = 1 /* "r" */,
    RainAndSnow = 2 /* "rs" */,
    Snow = 3 /* "s" */,

    COUNT = 4
};

class TWeatherInfo {
    R_READONLY(bool, IsCorrect, false);
    R_READONLY(EWeatherPrecType, PrecType, EWeatherPrecType::No);
    R_READONLY(double, PrecStrength, 0);
    R_READONLY(double, Cloudness, 0);
private:
    bool ParseReport(const NJson::TJsonValue& report);
public:
    TWeatherInfo() = default;
    TWeatherInfo(const NUtil::THttpReply& report);
    NJson::TJsonValue SerializeToJson() const;
    bool DeserializeFromJson(const NJson::TJsonValue& info);
    NDrive::NProto::TWeather SerializeToProto() const;
    bool DeserializeFromProto(const NDrive::NProto::TWeather& info);
};

class TWeatherAPI: public IStartStopProcess {
private:
    const TWeatherAPIConfig Config;
    TAsyncDelivery::TPtr AD;
    THolder<NNeh::THttpClient> Agent;

protected:
    virtual bool DoStart() override;
    virtual bool DoStop() override;
public:
    TWeatherAPI(const TWeatherAPIConfig& config)
        : Config(config)
    {
    }

    TMap<TString, TWeatherInfo> GetWeather(const TMap<TString, TGeoCoord>& coords) const;
};
