#pragma once

#include "config.h"

#include <drive/library/cpp/auth/tvm.h>

#include <util/generic/guid.h>

class TWebphoneClient {
public:
    class TResponse {
    public:
        TResponse(ui32 code, const TString& content);

        NJson::TJsonValue GetJsonContent() const;
        NJson::TJsonValue SerializeToJson() const;

    private:
        R_FIELD(ui32, Code, 0);
        R_FIELD(TString, Content);
    };

public:
    TWebphoneClient(const TWebphoneClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient);
    ~TWebphoneClient();

    NThreading::TFuture<TResponse> GetWebphoneAuthData(const TString& login, const TString& cookie, const NJson::TJsonValue& payload) const;
    NThreading::TFuture<TResponse> GetWebphoneAuthData(const TString& login, const NJson::TJsonValue& payload) const;

private:
    TWebphoneClientConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
    TMaybe<NDrive::TTvmAuth> TvmAuth;
};
