#include "config.h"

void TWebphoneClientConfig::Init(const TYandexConfig::Section* section) {
    Host = section->GetDirectives().Value<TString>("Host", Host);
    Port = section->GetDirectives().Value<ui32>("Port", Port);
    UseCallIdPrefix = section->GetDirectives().Value<bool>("UseCallIdPrefix", UseCallIdPrefix);
    CallIdPrefix = UseCallIdPrefix ? section->GetDirectives().Value<TString>("CallIdPrefix", CallIdPrefix) : "";
    BucketName = section->GetDirectives().Value<TString>("BucketName", BucketName);
    GenerateTokenUri = section->GetDirectives().Value<TString>("GenerateTokenUri", GenerateTokenUri);
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    SelfClientId = section->GetDirectives().Value("SelfClientId", SelfClientId);
    DestinationTvmId = section->GetDirectives().Value("DestinationTvmId", DestinationTvmId);
}

void TWebphoneClientConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "UseCallIdPrefix: " << UseCallIdPrefix << Endl;
    os << "CallIdPrefix: " << CallIdPrefix << Endl;
    os << "BucketName: " << BucketName << Endl;
    os << "GenerateTokenUri: " << GenerateTokenUri << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "SelfClientId: " << SelfClientId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
}

TWebphoneClientConfig TWebphoneClientConfig::ParseFromString(const TString& configStr) {
    TWebphoneClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
