#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/string_utils/url/url.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
#include <rtline/util/types/accessor.h>

#include <util/stream/file.h>

class TWebphoneClientConfig {
    R_READONLY(TString, Host, "tel.yandex-team.ru");
    R_READONLY(ui32, Port, 443);
    R_READONLY(TString, GenerateTokenUri, "/dev/?/mod.cipt-admin/API/USER/{$login}/GENERATESIPCHALENGE");
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(10));
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(bool, UseCallIdPrefix, true);
    R_READONLY(TString, CallIdPrefix, "tst_");
    R_READONLY(TString, BucketName, "carsharing-telephony");
    R_FIELD(ui32, SelfClientId, 0);
    R_FIELD(ui32, DestinationTvmId, 0);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TWebphoneClientConfig ParseFromString(const TString& configStr);
};
