#include "client.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/str.h>

Y_UNIT_TEST_SUITE(WhsdRealClient) {

    TString GetConfigString() {
        return R"(
            Uri: https://mcabinet.nch-spb.com:443/
            Login: login
            RowsToRead: 50
            <RequestConfig>
                MaxAttempts: 1
            </RequestConfig>
            RequestTimeout: 20s
        )";
    }

    Y_UNIT_TEST(RealConnection) {
        const TString configString = GetConfigString();
        auto config = TWhsdClientConfig::ParseFromString(configString);
        config.SetLogin("fill me!");
        config.SetPassword("fill me!");
        config.SetRowsToRead(10);
        TWhsdClient whsd(config);

        TInstant from = TInstant::ParseIso8601("2020-05-01T07:00:00.000000+00:00");
        TInstant to = TInstant::ParseIso8601("2020-05-02T07:00:00.000000+00:00");
        auto f = whsd.GetTransponderEvents(from, to);
        auto result = f.GetValue(TDuration::Seconds(20));
        UNIT_ASSERT_C(f.Initialized() && f.HasValue(), whsd.GetErrors().GetStringReport());
        auto events = result.GetTransponderEvents();
        UNIT_ASSERT_VALUES_EQUAL(events.size(), 10);
        UNIT_ASSERT_VALUES_EQUAL(events[0].GetTransponderId(), "6362875000008391674");

        auto f2 = result.GetNextPageRequest();
        auto result2 = f2.GetValue(TDuration::Seconds(20));
        UNIT_ASSERT_C(f2.Initialized() && f2.HasValue() && !f2.HasException(), whsd.GetErrors().GetStringReport());
        auto events2 = result2.GetTransponderEvents();
        UNIT_ASSERT_VALUES_EQUAL(events2.size(), 5);
        UNIT_ASSERT_VALUES_EQUAL(events2[0].GetTransponderId(), "6362875000007785298");
    }
}
