#include "config.h"

#include <util/stream/file.h>

TWhsdClientConfig TWhsdClientConfig::ParseFromString(const TString& configStr) {
    TWhsdClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}

bool TWhsdClientConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    Login = section->GetDirectives().Value<TString>("Login", Login);
    RowsToRead = section->GetDirectives().Value<ui32>("RowsToRead", RowsToRead);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    SecretPath = section->GetDirectives().Value("SecretPath", SecretPath);
    if (!SecretPath.Exists()) {
        return false;
    }
    Password = TIFStream(SecretPath).ReadAll();
    if (!Password) {
        return false;
    }
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
    return true;
}

void TWhsdClientConfig::ToString(IOutputStream& os) const{
    os << "Uri: " << Uri << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "Login: " << Login << Endl;
    os << "Password: " << Password << Endl;
    os << "RowsToRead: " << RowsToRead << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}
