#pragma once

#include <rtline/library/deprecated/async_impl/config.h>
#include <rtline/util/types/accessor.h>

class TWhsdClientConfig {
    R_FIELD(TString, Uri, "https://mcabinet.nch-spb.com:443/");
    R_FIELD(TString, Login);
    R_FIELD(TString, Password);
    R_FIELD(TFsPath, SecretPath);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(20));
    R_FIELD(ui32, RowsToRead, 10);
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);

public:
    static TWhsdClientConfig ParseFromString(const TString& configStr);
    bool Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
