#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>
#include <rtline/util/types/messages_collector.h>
#include <library/cpp/tvmauth/client/facade.h>

class TYaDocClient {
public:
    struct TDocument {
        ui64 Id;
        TString Number;
        TInstant Date;
        TString Type;
    };

    struct TRawDocument {
        TString Buffer;
        TString MimeType;

        TRawDocument(const NUtil::THttpReply& reply);
    };

    using TDocuments = TVector<TDocument>;

public:
    TYaDocClient(const TYaDocClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient)
        : Config(config)
        , TvmClient(tvmClient)
    {
        Client = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    NThreading::TFuture<TDocuments> GetDocuments(TInstant fromTs, TInstant toTs, const TString& contractId) const;
    NThreading::TFuture<TRawDocument> GetDocumentById(const TString& id) const;
    NThreading::TFuture<TRawDocument> GetArchive(const TVector<TString>& ids) const;

private:
    NThreading::TFuture<TRawDocument> GetBinaryFile(const TString& uri) const;

    THolder<NNeh::THttpClient> Client;
    const TYaDocClientConfig& Config;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};
