#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

void TYaDocClientConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    PathPrefix = section->GetDirectives().Value<TString>("PathPrefix", PathPrefix);

    SelfTvmId = section->GetDirectives().Value<ui32>("SelfTvmId", SelfTvmId);
    AssertCorrectConfig(!!SelfTvmId, "absent SelfTvmId");
    DestinationTvmId = section->GetDirectives().Value<ui32>("DestinationTvmId", DestinationTvmId);
    AssertCorrectConfig(!!DestinationTvmId, "absent DestinationTvmId");
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
    MaxPeriod = section->GetDirectives().Value<TDuration>("MaxPeriod", MaxPeriod);
}

void TYaDocClientConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "PathPrefix: " << PathPrefix << Endl;
    os << "SelfTvmId: " << SelfTvmId << Endl;
    os << "DestinationTvmId: " << DestinationTvmId << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
    os << "MaxPeriod: " << MaxPeriod << Endl;
}

TYaDocClientConfig TYaDocClientConfig::ParseFromString(const TString& configStr) {
    TYaDocClientConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
