#pragma once

#include <library/cpp/yconf/conf.h>
#include <rtline/util/types/accessor.h>
#include <rtline/library/metasearch/simple/config.h>

class TYaDocClientConfig {
    R_READONLY(TString, Uri, "https://yadoc.mba.yandex-team.ru/");
    R_READONLY(TString, PathPrefix, "public/api/");
    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(10));

    R_READONLY(TDuration, MaxPeriod, TDuration::Days(28));
public:
    static TYaDocClientConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
