#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>
#include <library/cpp/json/writer/json_value.h>
#include <rtline/util/types/messages_collector.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <drive/backend/users/user_documents.h>

struct TYangRequestError : public virtual yexception {
};

struct TYangJsonParseException : public virtual yexception {
};

struct TYangAuthException : public virtual yexception {
};

struct TYangNotFoundException : public TYangRequestError {
};

class TYangClient {
public:
    TYangClient(const TYangClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient = nullptr)
        : Config(config)
        , Client(MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig()))
        , TvmClient(tvmClient) {
        }

    virtual ~TYangClient() = default;

    virtual NThreading::TFuture<NJson::TJsonValue> RequestAssignmentAsync(const TString& assignmentId) const;
    virtual NJson::TJsonValue RequestAssignmentSync(const TString& assignmentId) const;

    virtual NThreading::TFuture<NNeh::THttpReply> RequestAsync(NNeh::THttpRequest& request) const;
    virtual NNeh::THttpReply RequestSync(NNeh::THttpRequest& request) const;

private:
    virtual void ApplyAuth(NNeh::THttpRequest& request) const;

private:
    const TYangClientConfig Config;
    THolder<NNeh::THttpClient> Client;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};

class TFakeYangClient: public TYangClient {
private:
    using TBase = TYangClient;

private:
    mutable TMap<TString, NJson::TJsonValue> assignments;

public:
    TFakeYangClient() : TYangClient(TYangClientConfig()) {
    }

    virtual NThreading::TFuture<NJson::TJsonValue> RequestAssignmentAsync(const TString& assignmentId) const override;
    virtual NJson::TJsonValue RequestAssignmentSync(const TString& assignmentId) const override;
    void InsertAssignment(const TString& assignmentId, const NJson::TJsonValue& assignment) const;
};
