#pragma once

#include <util/string/cast.h>
#include <library/cpp/yconf/conf.h>
#include <rtline/util/types/accessor.h>
#include <rtline/library/metasearch/simple/config.h>

class TYangClientConfig {
public:
    enum class EAuthType {
        Undefined,
        OAuth,
        TVM
    };

private:
    R_READONLY(TString, Uri, "https://yang.yandex-team.ru");
    R_READONLY(TString, PathPrefix, "api/v1/");
    R_READONLY(EAuthType, AuthType, EAuthType::Undefined);

    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    
    R_READONLY(TString, AuthToken);
    R_READONLY(TString, TokenPath);

    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(10));

public:
    TYangClientConfig() = default;

    static TYangClientConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
