#include "ytprof.h"

#include <absl/debugging/stacktrace.h>
#include <yt/yt/core/concurrency/action_queue.h>
#include <yt/yt/core/concurrency/poller.h>
#include <yt/yt/core/concurrency/thread_pool.h>
#include <yt/yt/core/concurrency/thread_pool_poller.h>
#include <yt/yt/library/ytprof/heap_profiler.h>
#include <yt/yt/library/ytprof/http/handler.h>

namespace NDrive {

NYT::NHttp::IServerPtr CreateYTProfServer(int port) {
    // inspired by https://a.yandex-team.ru/arcadia/yt/yt/library/ytprof/example/main.cpp?rev=r9700078

    NYT::NYTProf::EnableMemoryProfilingTags();
    absl::SetStackUnwinder(NYT::NYTProf::AbslStackUnwinder);

    const auto& poller = NYT::NConcurrency::CreateThreadPoolPoller(1, "YTProf Server");
    const auto& server = NYT::NHttp::CreateServer(port, poller);

    NYT::NYTProf::Register(server, "");
    
    return server;
}

} // namespace NDrive
