package auth

import (
	"fmt"
	"net/http"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

// Provider represents auth provider.
type Provider interface {
	UpdateRequest(req *http.Request) error
}

// OAuth represents OAuth auth provider.
type OAuth string

// UpdateRequest updates request with OAuth token.
func (t OAuth) UpdateRequest(req *http.Request) error {
	req.Header.Add("Authorization", fmt.Sprintf("OAuth %s", t))
	return nil
}

// ServiceTicket represents TVM2 service ticket auth provider.
type ServiceTicket struct {
	TVM    tvm.Client
	Target string
}

// UpdateRequest updates request with TVM2 ServiceTicket token.
func (t ServiceTicket) UpdateRequest(req *http.Request) error {
	ticket, err := t.TVM.GetServiceTicketForAlias(req.Context(), t.Target)
	if err != nil {
		return err
	}
	req.Header.Add("X-Ya-Service-Ticket", ticket)
	return nil
}
